<?php
include 'conexao.php';
session_start();

if (!isset($_GET['turma_id'])) {
    echo "Turma não selecionada.";
    exit;
}

$turma_id = intval($_GET['turma_id']);
$resTurma = $conn->query("SELECT nome, classe, curso, turno FROM turmas WHERE id = $turma_id");
$turma = $resTurma->fetch_assoc();
$descricaoFiltro = "da Turma: " . $turma['nome'] . " " . $turma['classe'] . " " . $turma['curso'] . " (" . $turma['turno'] . ")";
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Horário da Turma</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        h3 { text-align: center; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        td, th { border: 1px solid #ccc; padding: 8px; text-align: center; }

        @media print {
            button { display: none; }
        }
    </style>
</head>
<body>

<h3>Horário <?= $descricaoFiltro ?></h3>

<?php
$dias_semana = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
$horario = [];

$sql = "SELECT h.dia, h.tempo, h.disciplina, h.professor
        FROM horario h
        WHERE h.turma_id = $turma_id";

$res = $conn->query($sql);

while ($row = $res->fetch_assoc()) {
    $hora = $row['tempo'];
    $dia = $row['dia'];
    $texto = $row['disciplina'] . "<br><small>" . $row['professor'] . "</small>";
    $horario[$hora][$dia] = $texto;
}

$faixas_horas = array_keys($horario);
sort($faixas_horas);
?>

<table>
    <thead>
    <tr>
        <th>Horário</th>
        <?php foreach ($dias_semana as $dia): ?>
            <th><?= $dia ?></th>
        <?php endforeach; ?>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($faixas_horas as $hora): ?>
        <tr>
            <td><?= $hora ?></td>
            <?php foreach ($dias_semana as $dia): ?>
                <td><?= $horario[$hora][$dia] ?? '' ?></td>
            <?php endforeach; ?>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<!-- Assinatura -->
<br><br><br>
<div style="text-align: right; margin-top: 30px; font-family: Arial, sans-serif;">

 <strong>O Subdirector Pedagógico</strong>

 <br> _______________________
                                   
</div>

<!-- Botão de imprimir -->
<div style="text-align:center; margin-top:20px;">
    <button onclick="window.print()">Imprimir</button>
</div>

</body>
</html>
